/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.dynamic.InventoryMenuModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.recipe.partbuilder.Pattern;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.capability.ToolInventoryCapability;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ToolBeltModifier
extends InventoryMenuModifier {
    private static final Pattern PATTERN = new Pattern("tconstruct", "tool_belt");
    private static final ResourceLocation SLOT_OVERRIDE = TConstruct.getResource("tool_belt_override");
    public static final GenericLoaderRegistry.IGenericLoader<ToolBeltModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<ToolBeltModifier>(){

        public ToolBeltModifier deserialize(JsonObject json) {
            JsonArray slotJson = GsonHelper.m_13933_((JsonObject)json, (String)"level_slots");
            int[] slots = new int[slotJson.size()];
            for (int i = 0; i < slots.length; ++i) {
                slots[i] = GsonHelper.m_13897_((JsonElement)slotJson.get(i), (String)("level_slots[" + i + "]"));
                if (i <= 0 || slots[i] > slots[i - 1]) continue;
                throw new JsonSyntaxException("level_slots must be increasing");
            }
            return new ToolBeltModifier(slots);
        }

        public ToolBeltModifier fromNetwork(FriendlyByteBuf buffer) {
            return new ToolBeltModifier(buffer.m_130100_());
        }

        public void serialize(ToolBeltModifier object, JsonObject json) {
            JsonArray jsonArray = new JsonArray();
            for (int i : object.counts) {
                jsonArray.add((Number)i);
            }
            json.add("level_slots", (JsonElement)jsonArray);
        }

        public void toNetwork(ToolBeltModifier object, FriendlyByteBuf buffer) {
            buffer.m_130089_(object.counts);
        }
    };
    private final int[] counts;

    public ToolBeltModifier(int[] counts) {
        super(counts[0]);
        this.counts = counts;
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    public Component getDisplayName(int level) {
        return ModifierLevelDisplay.PLUSES.nameForLevel(this, level);
    }

    @Override
    public int getPriority() {
        return 85;
    }

    private int getProperSlots(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level > this.counts.length) {
            return 9;
        }
        return this.counts[level - 1];
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        int slots;
        int properSlots = this.getProperSlots(level);
        if (properSlots < 9) {
            slots = properSlots;
            ResourceLocation key = this.getInventoryKey();
            IModDataView modData = context.getPersistentData();
            if (modData.contains(key, 9)) {
                ListTag list = (ListTag)modData.get(key, GET_COMPOUND_LIST);
                int maxSlot = 0;
                for (int i = 0; i < list.size(); ++i) {
                    int newSlot = list.m_128728_(i).m_128451_("Slot");
                    if (newSlot <= maxSlot) continue;
                    maxSlot = newSlot;
                }
                if ((maxSlot = Math.min(maxSlot + 1, 9)) > properSlots) {
                    volatileData.putInt(SLOT_OVERRIDE, maxSlot);
                    slots = maxSlot;
                }
            }
        } else {
            slots = 9;
        }
        ToolInventoryCapability.addSlots(volatileData, slots);
    }

    @Override
    public int getSlots(IToolContext tool, int level) {
        int properSlots = this.getProperSlots(level);
        if (properSlots >= 9) {
            return 9;
        }
        return Mth.m_14045_((int)tool.getVolatileData().getInt(SLOT_OVERRIDE), (int)properSlots, (int)9);
    }

    @Override
    public ValidatedResult validate(IToolStackView tool, int level) {
        return this.validateForMaxSlots(tool, this.getProperSlots(level));
    }

    @Override
    public boolean startInteract(IToolStackView tool, ModifierEntry modifier, Player player, EquipmentSlot equipmentSlot, TooltipKey keyModifier) {
        if (keyModifier == TooltipKey.SHIFT) {
            return super.startInteract(tool, modifier, player, equipmentSlot, keyModifier);
        }
        if (keyModifier == TooltipKey.NORMAL || keyModifier == TooltipKey.CONTROL) {
            ListTag original;
            if (player.f_19853_.f_46443_) {
                return true;
            }
            boolean didChange = false;
            int slots = this.getSlots((IToolContext)tool, modifier.getLevel());
            ModDataNBT persistentData = tool.getPersistentData();
            ListTag list = new ListTag();
            boolean[] swapped = new boolean[slots];
            Inventory inventory = player.m_150109_();
            ResourceLocation key = this.getInventoryKey();
            if (persistentData.contains(key, 9) && !(original = (ListTag)persistentData.get(key, GET_COMPOUND_LIST)).isEmpty()) {
                for (int i = 0; i < original.size(); ++i) {
                    CompoundTag compoundNBT = original.m_128728_(i);
                    int slot = compoundNBT.m_128451_("Slot");
                    if (slot >= slots) continue;
                    ItemStack hotbar = inventory.m_8020_(slot);
                    if (hotbar.m_41619_() || !ToolInventoryCapability.isBlacklisted(hotbar)) {
                        ItemStack parsed = ItemStack.m_41712_((CompoundTag)compoundNBT);
                        inventory.m_6836_(slot, parsed);
                        if (!hotbar.m_41619_()) {
                            list.add((Object)ToolBeltModifier.write(hotbar, slot));
                        }
                        didChange = true;
                    } else {
                        list.add((Object)compoundNBT);
                    }
                    swapped[slot] = true;
                }
            }
            for (int i = 0; i < slots; ++i) {
                ItemStack hotbar;
                if (swapped[i] || (hotbar = player.m_150109_().m_8020_(i)).m_41619_() || ToolInventoryCapability.isBlacklisted(hotbar)) continue;
                list.add((Object)ToolBeltModifier.write(hotbar, i));
                inventory.m_6836_(i, ItemStack.f_41583_);
                didChange = true;
            }
            if (didChange) {
                persistentData.put(key, (Tag)list);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Pattern getPattern(IToolStackView tool, ModifierEntry modifier, int slot, boolean hasStack) {
        return hasStack ? null : PATTERN;
    }
}

